/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.fastbench.util;

import dev.shadowsoffire.fastbench.mixin.AbstractContainerMenuInvoker;
import dev.shadowsoffire.fastbench.net.RecipePayload;
import dev.shadowsoffire.fastbench.util.CraftingInventoryExt;
import dev.shadowsoffire.fastbench.util.SlotUpdateManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class FastBenchUtil {
    public static void queueSlotUpdate(Level level, Player player, CraftingInventoryExt inv, ResultContainer result) {
        SlotUpdateManager.queueSlotUpdate(level, player, inv, result);
    }

    public static void slotChangedCraftingGrid(Level world, Player player, CraftingInventoryExt inv, ResultContainer result) {
        if (!world.isClientSide && inv.checkChanges) {
            ItemStack itemstack = ItemStack.EMPTY;
            CraftingInput input = inv.asCraftInput();
            RecipeHolder<CraftingRecipe> oldRecipe = result.getRecipeUsed();
            RecipeHolder<CraftingRecipe> recipe = oldRecipe;
            if (recipe == null || !((CraftingRecipe)recipe.value()).matches((RecipeInput)input, world)) {
                recipe = FastBenchUtil.findRecipe(input, world);
            }
            if (recipe != null) {
                itemstack = ((CraftingRecipe)recipe.value()).assemble((RecipeInput)input, (HolderLookup.Provider)world.registryAccess());
            }
            if (oldRecipe != recipe || result.getItem(0).isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new RecipePayload(recipe, itemstack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                result.setItem(0, itemstack);
                result.setRecipeUsed(recipe);
            } else if (recipe != null && (((CraftingRecipe)recipe.value()).isSpecial() || !((CraftingRecipe)recipe.value()).getClass().getName().startsWith("net.minecraft") && !ItemStack.matches((ItemStack)itemstack, (ItemStack)result.getItem(0)))) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new RecipePayload(recipe, itemstack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                result.setItem(0, itemstack);
                result.setRecipeUsed(recipe);
            }
        }
    }

    public static ItemStack handleShiftCraft(Player player, AbstractContainerMenu container, Slot resultSlot, CraftingInventoryExt craftMatrix, ResultContainer craftResult, int outStart, int outEnd) {
        return FastBenchUtil.handleShiftCraft(player, container, resultSlot, craftMatrix, craftResult, (menu, stack) -> !((AbstractContainerMenuInvoker)menu)._moveItemStackTo(stack, outStart, outEnd, true));
    }

    public static ItemStack handleShiftCraft(Player player, AbstractContainerMenu container, Slot resultSlot, CraftingInventoryExt craftMatrix, ResultContainer craftResult, OutputMover mover) {
        ItemStack outputCopy = ItemStack.EMPTY;
        CraftingInput input = craftMatrix.asCraftInput();
        if (resultSlot != null && resultSlot.hasItem()) {
            craftMatrix.checkChanges = false;
            RecipeHolder recipe = craftResult.getRecipeUsed();
            while (recipe != null && ((CraftingRecipe)recipe.value()).matches((RecipeInput)input, player.level())) {
                ItemStack recipeOutput = ((CraftingRecipe)recipe.value()).assemble((RecipeInput)input, (HolderLookup.Provider)player.level().registryAccess());
                if (recipeOutput.isEmpty()) {
                    throw new RuntimeException("A recipe matched but produced an empty output - Offending Recipe : " + String.valueOf(recipe.id()) + " - This is NOT a bug in FastWorkbench!");
                }
                outputCopy = recipeOutput.copy();
                recipeOutput.onCraftedBy(player.level(), player, 1);
                EventHooks.firePlayerCraftingEvent((Player)player, (ItemStack)recipeOutput, (Container)craftMatrix);
                if (!player.level().isClientSide && mover.merge(container, recipeOutput)) {
                    craftMatrix.checkChanges = true;
                    return ItemStack.EMPTY;
                }
                ((ResultSlot)resultSlot).removeCount += outputCopy.getCount();
                resultSlot.onTake(player, recipeOutput);
                FastBenchUtil.resetStackedContents(input);
            }
            craftMatrix.checkChanges = true;
            FastBenchUtil.slotChangedCraftingGrid(player.level(), player, craftMatrix, craftResult);
        }
        return outputCopy;
    }

    @Nullable
    public static RecipeHolder<CraftingRecipe> findRecipe(CraftingInput input, Level world) {
        return world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, world).orElse(null);
    }

    public static void resetStackedContents(CraftingInput input) {
        StackedContents contents = input.stackedContents();
        contents.clear();
        for (ItemStack i : input.items()) {
            if (i.isEmpty()) continue;
            contents.accountStack(i, 1);
        }
    }

    public static interface OutputMover {
        public boolean merge(AbstractContainerMenu var1, ItemStack var2);
    }
}

